function cdx_new = insert_index_members(CDX)
% --------------------------------------------------------------------------------------------------
% Populate indicator matrix of index members
% --------------------------------------------------------------------------------------------------
% CDX                           ... credit index structure (see 'all_steps_in_a_row.m')
% --------------------------------------------------------------------------------------------------
% sample call: insert_index_members(CDX_NA_IG2)
% --------------------------------------------------------------------------------------------------

% Import index members from Bloomberg
series_members = {};
[trash, series_members{1}] = xlsread('c:/thesis/data/bloomberg/cdx3.na.ig.xls', 1, 'D2:D1000');
[trash, series_members{2}] = xlsread('c:/thesis/data/bloomberg/cdx4.na.ig.xls', 1, 'D2:D1000');
[trash, series_members{3}] = xlsread('c:/thesis/data/bloomberg/cdx5.na.ig.xls', 1, 'D2:D1000');
[trash, series_members{4}] = xlsread('c:/thesis/data/bloomberg/cdx6.na.ig.xls', 1, 'D2:D1000');
[trash, series_members{5}] = xlsread('c:/thesis/data/bloomberg/cdx7.na.ig.xls', 1, 'D2:D1000');
rollover_dates = datenum({'09/21/2004' '03/21/2005' '09/20/2005' '03/20/2006' '09/20/2006' '03/20/2007' '09/20/2007'});
CDX.index_members = zeros(length(CDX.dates{1}), length(CDX.portfolio));


% Compare Bloomberg list with ticker symbols in portfolio
for j=1:(length(rollover_dates)-1)
    % Determine relevant date range
    start_pos = find(CDX.dates{1} >= rollover_dates(j), 1, 'first');
    end_pos = find(CDX.dates{1} < rollover_dates(j+1), 1, 'last');
    if (isempty(start_pos) | isempty(end_pos))
        continue;
    end
    
    % Match by tickers
    for i=1:length(CDX.portfolio)
        if ismember(CDX.portfolio(i).ticker, series_members{j})
            CDX.index_members(start_pos:end_pos,i) = 1;
        end
        % Manually match strange tickers
        % 'Amern Axle & Mfg Inc'
        if (strcmp('AXL-Inc', CDX.portfolio(i).ticker) & ismember('AXL', series_members{j}))
            CDX.index_members(start_pos:end_pos,i) = 1;
        end
        % 'MBNA Corp' 
        if (strcmp('KRB', CDX.portfolio(i).ticker) & ismember('BAC', series_members{j}))
            CDX.index_members(start_pos:end_pos,i) = 1;
        end 
        % 'Bombardier Cap Inc'
        if (strcmp('BOMB-CapInc', CDX.portfolio(i).ticker) & ismember('BOMB', series_members{j}))
            CDX.index_members(start_pos:end_pos,i) = 1;
        end 
        % 'Avis Budget Group Inc'
        if (strcmp('AVBDGT', CDX.portfolio(i).ticker) & ismember('CAR', series_members{j}))
            CDX.index_members(start_pos:end_pos,i) = 1;
        end
        % 'CBS Corp'
        if (strcmp('CBSCOR', CDX.portfolio(i).ticker) & ismember('CBS', series_members{j}))
            CDX.index_members(start_pos:end_pos,i) = 1;
        end
        % 'Ctrywde Home Lns Inc'
        if (strcmp('CCR-HomeLoans', CDX.portfolio(i).ticker) & ismember('CFC', series_members{j}))
            CDX.index_members(start_pos:end_pos,i) = 1;
        end
        % 'Cox Comms Inc'
        if (strcmp('COX-CommInc', CDX.portfolio(i).ticker) & ismember('COXENT', series_members{j}))
            CDX.index_members(start_pos:end_pos,i) = 1;
        end
%         % 'Delphi Corp'
%         if (strcmp('DPH', CDX.portfolio(i).ticker) & ismember('DPH', series_members{j}))
%             CDX.index_members(start_pos:end_pos,i) = 1;
%         end
        % 'EOP Oper Ltd Pship'
        if (strcmp('EOP-EOPOpLP', CDX.portfolio(i).ticker) & ismember('EOP', series_members{j}))
            CDX.index_members(start_pos:end_pos,i) = 1;
        end
        % 'Embarq Corp'
        if (strcmp('EMBRQ', CDX.portfolio(i).ticker) & ismember('EQ', series_members{j}))
            CDX.index_members(start_pos:end_pos,i) = 1;
        end
        
        % EXP - EXPEDIA?
        
        % 'Gen Elec Cap Corp'
        if (strcmp('GE-CapCorp', CDX.portfolio(i).ticker) & ismember('GE', series_members{j}))
            CDX.index_members(start_pos:end_pos,i) = 1;
        end
        % 'Harrahs Oper Co Inc'
        if (strcmp('HET-OpCo', CDX.portfolio(i).ticker) & ismember('HET', series_members{j}))
            CDX.index_members(start_pos:end_pos,i) = 1;
        end
        % 'Ingersoll Rand Co'
        if (strcmp('IR-NJ', CDX.portfolio(i).ticker) & ismember('IR', series_members{j}))
            CDX.index_members(start_pos:end_pos,i) = 1;
        end
        % 'Knight Ridder Inc'
        if (strcmp('KRI', CDX.portfolio(i).ticker) & ismember('MNI', series_members{j}))
            CDX.index_members(start_pos:end_pos,i) = 1;
        end
        % 'News America Inc'
        if (strcmp('NWS-AmInc', CDX.portfolio(i).ticker) & ismember('NWS', series_members{j}))
            CDX.index_members(start_pos:end_pos,i) = 1;
        end
        % 'Residential Cap Corp'
        if (strcmp('GM-ResCap', CDX.portfolio(i).ticker) & ismember('RESCAP', series_members{j}))
            CDX.index_members(start_pos:end_pos,i) = 1;
        end        
        % 'R R Donnelley & Sons Co'
        if (strcmp('DNY', CDX.portfolio(i).ticker) & ismember('RRD', series_members{j}))
            CDX.index_members(start_pos:end_pos,i) = 1;
        end
        % 'Sears Roebuck Accep Corp'
        if (strcmp('SHC-Acceptance', CDX.portfolio(i).ticker) & ismember('SHLD', series_members{j}))
            CDX.index_members(start_pos:end_pos,i) = 1;
        end 
        % 'Simon Ppty Gp L P'
        if (strcmp('SPG-LP', CDX.portfolio(i).ticker) & ismember('SPG', series_members{j}))
            CDX.index_members(start_pos:end_pos,i) = 1;
        end 
        % 'Time Warner Inc'   
        if (strcmp('TW', CDX.portfolio(i).ticker) & ismember('TWX', series_members{j}))
            CDX.index_members(start_pos:end_pos,i) = 1;
        end           
    end    
end
cdx_new = CDX;

% tmp = {CDX.portfolio.ticker};
% found_tickers = tmp(sum(CDX.index_members)>0);
% ever_CDX = union(union(union(union(series_members{1}, series_members{2}), series_members{3}), series_members{4}), series_members{5});
% ind_found = ismember(ever_CDX, found_tickers);
% not_found = ever_CDX(~ind_found);
% 
% setdiff(not_found, {'AXL' 'BAC' 'BOMB' 'CAR' 'CBS' 'CFC' 'COXENT' 'EOP' 'EQ' 'GE' 'HET' 'IR' 'MNI' 'NWS' 'RESCAP' 'RRD' 'SHLD' 'SPG' 'TWX'})
% 
% strmatch('R R', {CDX.portfolio.company}')

